/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef __REFTCLIB_H
#define __REFTCLIB_H

#include "drmchkerr.h"
#include "drmcommon.h"

#include <stdio.h>
#include "DX_VOS_Stdio.h"
#include "DX_VOS_String.h"
#ifdef WINCE_TEST
#include <drmtypes.h>
#include<windows.h>
#endif

#ifdef __TMS320C55X__
#define __cdecl
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*************
*	Implement the following three functions.
*	The test framework calls PreTestCase before each test case and PostTestCase after each test case.
*	The test framework calls WrapTestRun(IDFromCmdLine, TRUE) before running all your test cases and
*	calls WrapTestRun(IDFromCmdLine, FALSE) after running all your test cases.
*
*	You can also define these in your cpp file to get the default implementations (no op)
*		IMPLEMENT_DEFAULT_WARPTEST
*		IMPLEMENT_DEFAULT_PRETESTCASE
*		IMPLEMENT_DEFAULT_POSTTESTCASE
*	or
*		IMPLEMENT_DEFAULT_PRETESTCASE_AND_POSTTESTCASE
**************/

typedef DRM_RESULT (* LPFNPRETESTCASE)(long lTCID, char *strTCName);
typedef DRM_RESULT (* LPFNPOSTTESTCASE)(long lTCID, char *strTCName);
typedef DRM_RESULT (* LPFNWRAPTESTRUN)(long lTCID, DRM_BOOL fPreTestRun);


/*
DRM_RESULT PreTestCase(long lTCID, char *strTCName);
DRM_RESULT PostTestCase(long lTCID, char *strTCName);
DRM_RESULT WrapTestRun(long lTCID, DRM_BOOL fPreTestRun);
*/

#define IMPLEMENT_DEFAULT_PRETESTCASE \
	static DRM_RESULT PreTestCase(long lTCID, char *strTCName){return DRM_SUCCESS;}

#define IMPLEMENT_DEFAULT_POSTTESTCASE \
	static DRM_RESULT PostTestCase(long lTCID, char *strTCName){return DRM_SUCCESS;}

#define IMPLEMENT_DEFAULT_PRETESTCASE_AND_POSTTESTCASE \
	IMPLEMENT_DEFAULT_PRETESTCASE \
	IMPLEMENT_DEFAULT_POSTTESTCASE

#define IMPLEMENT_DEFAULT_WARPTEST \
	static DRM_RESULT WrapTestRun(long lTCID, DRM_BOOL fPreTestRun){return DRM_SUCCESS;}

/************** 
*	All your api test functions should use this prototype.
*	argc is the number of arguments. argv is an array of arguments.
***************/
typedef DRM_RESULT (*TAPITester)(long argc, char **argv);

/************** 
*	You can optionally call this function in your test implementation to log your messages
*	szTag is the tag name in the xml log file. The usage of szMessageFmt and the variable arglist
*	is the same as sprintf.
***************/
void Log(char *szTag, char *szMessageFmt, ...);

/************** 
*	Normally you have one test script file and build your api map using these macros:
*	
*	BEGIN_APIMAP("myscript.txt")
*		API_ENTRY(MyTest1)
*		API_ENTRY(MyTest2)
*	END_APIMAP
*
*	If you have multiple test script files, you can build a script file list and then use
*	BEGIN_APIMAP_WITH_SCRIPT_LIST to start your api map.
*
*	BEGIN_TEST_SCRIPT_LIST
*		TEST_SCRIPT_ENTRY("MyScript1.txt")
*		TEST_SCRIPT_ENTRY("MyScript2.txt")
*	END_TEST_SCRIPT_LIST
*
*	BEGIN_APIMAP_WITH_SCRIPT_LIST
*		API_ENTRY(MyTest1)
*		API_ENTRY(MyTest2)
*	END_APIMAP
***************/

#define BEGIN_TEST_SCRIPT_LIST \
	static char* g_szTestScriptFileName[]= {

#define TEST_SCRIPT_ENTRY(f) \
	f,

#define END_TEST_SCRIPT_LIST \
	NULL};

#ifdef WINCE_TEST
#define BEGIN_APIMAP_WITH_SCRIPT_LIST(ModuleName) \
int WINAPI WinMain(	HINSTANCE hInstance,HINSTANCE hPrevInstance,LPTSTR lpCmdLine,int nCmdShow)\
{\
	TAPIMapEntry apiMap[] = {

#define API_ENTRY(f) {#f, f},

#define END_APIMAP \
	{NULL, NULL}}; \
	int argc, iReturn;		\
	char *argv[10]={NULL}; \
	argc=ConvertArguments(lpCmdLine,argv);  \
	iReturn=DoTest(argc, argv, g_szTestScriptFileName, apiMap, PreTestCase, PostTestCase, WrapTestRun); \
	FreeArgv(argc, argv); \
	return iReturn;				\
}
 
#else

#ifdef REF_LIBRARY
#define BEGIN_APIMAP_WITH_SCRIPT_LIST(ModuleName) \
    int __cdecl _##ModuleName##_main(int argc, char** argv)\
{\
	TAPIMapEntry apiMap[] = {

#else
#define BEGIN_APIMAP_WITH_SCRIPT_LIST(ModuleName) \
int __cdecl main(int argc, char** argv)\
{\
	TAPIMapEntry apiMap[] = {
#endif

#define API_ENTRY(f) {#f, f},

#define END_APIMAP \
	{NULL, NULL}}; \
	DX_VOS_Printf( "Microsoft (R) %s\nCopyright (C) Microsoft Corporation. All rights reserved.\n\n", "DRM Test Tool" ); \
	return DoTest(argc, argv, g_szTestScriptFileName, apiMap, PreTestCase, PostTestCase, WrapTestRun); \
}
#endif

/* BEGIN_APIMAP is a special case of BEGIN_APIMAP_WITH_SCRIPT_LIST. It only has one test script file. */
#define BEGIN_APIMAP(ModuleName, tcFileName) \
	BEGIN_TEST_SCRIPT_LIST \
		TEST_SCRIPT_ENTRY(tcFileName) \
	END_TEST_SCRIPT_LIST \
	BEGIN_APIMAP_WITH_SCRIPT_LIST(ModuleName)

typedef struct {
	char *m_szAPI;
	TAPITester m_pAPI;
} TAPIMapEntry;

/* This is the entry point implemented by the test framework */
int DoTest(int, char**, char**, TAPIMapEntry*, LPFNPRETESTCASE, LPFNPOSTTESTCASE, LPFNWRAPTESTRUN);

#ifdef WINCE_TEST
int ConvertArguments(LPTSTR lpCmdLine, char* argv[]);
void FreeArgv(int argc,char* argv[]);
#endif

#ifdef __cplusplus
}
#endif

#endif
